package com.ElyStudio.leGaou.utilities;

import com.ElyStudio.leGaou.models.AboutApp;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.DailyQuizData;
import com.ElyStudio.leGaou.models.GetGameScreenData;
import com.ElyStudio.leGaou.models.GetLeaderboardData;
import com.ElyStudio.leGaou.models.GetPlayingHistory;
import com.ElyStudio.leGaou.models.GetQuestions;
import com.ElyStudio.leGaou.models.GetQuiz;
import com.ElyStudio.leGaou.models.GetQuizHistory;
import com.ElyStudio.leGaou.models.GetWalletData;
import com.ElyStudio.leGaou.models.HomeScreenData;
import com.ElyStudio.leGaou.models.InviteEarnData;
import com.ElyStudio.leGaou.models.QuizzeAvatars;
import com.ElyStudio.leGaou.models.UserData;

import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;

public interface ApiInterface {

    @FormUrlEncoded
    @POST("APIs/register.php")
    Call<ApiResponse> registerUser(
            @Field("uId") String uId,
            @Field("name") String name,
            @Field("email") String email,
            @Field("inviteCode") String inviteCode
    );

    @GET("APIs/avatars.php")
    Call<QuizzeAvatars> getAvatars();

    @FormUrlEncoded
    @POST("APIs/updateSignIn.php")
    Call<ApiResponse> updateSignIn(
            @Field("uId") String uId,
            @Field("name") String name,
            @Field("avatar") String avatar
    );

    @FormUrlEncoded
    @POST("APIs/getHomeScreenData.php")
    Call<HomeScreenData> getHomeScreenData(
            @Field("uId") String uId
    );

    @FormUrlEncoded
    @POST("APIs/getQuiz.php")
    Call<GetQuiz> getQuiz(
            @Field("categoryId") int categoryId
    );

    @FormUrlEncoded
    @POST("APIs/getQuestions.php")
    Call<GetQuestions> getQuestions(
            @Field("quizId") int quizId,
            @Field("difficulty") String difficulty,
            @Field("questionLimit") int questionLimit
    );

    @FormUrlEncoded
    @POST("APIs/playQuiz.php")
    Call<ApiResponse> playQuiz(
            @Field("uId") String uId,
            @Field("icon") String icon,
            @Field("activity") String activity,
            @Field("coins") int coins,
            @Field("paid") int paid
    );

    @FormUrlEncoded
    @POST("APIs/getQuizPrize.php")
    Call<ApiResponse> getQuizPrize(
            @Field("uId") String uId,
            @Field("quizName") String quizName,
            @Field("icon") String icon,
            @Field("color") int color,
            @Field("totalQuestions") int totalQuestions,
            @Field("questionAttempted") int questionAttempted,
            @Field("correctAnswers") int correctAnswers,
            @Field("wrongAnswers") int wrongAnswers,
            @Field("entryFee") int entryFee,
            @Field("prize") int prize,
            @Field("activity") String activity
    );

    @FormUrlEncoded
    @POST("APIs/getAdCoins.php")
    Call<ApiResponse> getAdCoins(
            @Field("uId") String uId,
            @Field("coins") int coins,
            @Field("activity") String activity,
            @Field("paid") int paid
    );

    @GET("APIs/getDailyQuizData.php")
    Call<DailyQuizData> getDailyQuizData();

    @FormUrlEncoded
    @POST("APIs/addCoins.php")
    Call<ApiResponse> addCoins(
            @Field("uId") String uId,
            @Field("coins") int coins,
            @Field("type") String type,
            @Field("activity") String activity
    );

    @FormUrlEncoded
    @POST("APIs/getInviteBonus.php")
    Call<ApiResponse> getInviteBonus(
            @Field("uId") String uId,
            @Field("inviteCode") String inviteCode,
            @Field("inviteSenderActivity") String inviteSenderActivity,
            @Field("inviteeActivity") String inviteeActivity
    );

    @FormUrlEncoded
    @POST("APIs/getInviteEarnData.php")
    Call<InviteEarnData> getInviteEarnData(
            @Field("inviteCode") String inviteCode
    );

    @GET("APIs/getGameScreenData.php")
    Call<GetGameScreenData> getGameScreenData();

    @GET("APIs/getLeaderboardData.php")
    Call<GetLeaderboardData> getLeaderboardData();

    @FormUrlEncoded
    @POST("APIs/getUserData.php")
    Call<UserData> getUserData(
            @Field("uId") String uId
    );

    @FormUrlEncoded
    @POST("APIs/getWalletData.php")
    Call<GetWalletData> getWalletData(
            @Field("uId") String uId
    );

    @FormUrlEncoded
    @POST("APIs/createWithdrawRequest.php")
    Call<ApiResponse> createWithdrawRequest(
            @Field("uId") String uId,
            @Field("method") String method,
            @Field("methodId") String methodId,
            @Field("icon") String icon,
            @Field("coins") int coins,
            @Field("amount") float amount,
            @Field("activity") String activity

    );

    @FormUrlEncoded()
    @POST("APIs/getPlayingHistory.php")
    Call<GetPlayingHistory> getPlayingHistoryCall(
            @Field("uId") String uId
    );

    @GET("APIs/getAboutApp.php")
    Call<AboutApp> getAboutApp();

    @FormUrlEncoded
    @POST("APIs/getQuizHistory.php")
    Call<GetQuizHistory> getQuizHistory(
            @Field("uId") String uId
    );

    @FormUrlEncoded
    @POST("APIs/updateUserName.php")
    Call<ApiResponse> updateName(
            @Field("uId") String uId,
            @Field("name") String name
    );

    @FormUrlEncoded
    @POST("APIs/updateAvatar.php")
    Call<ApiResponse> updateAvatar(
            @Field("uId") String uId,
            @Field("avatar") String avatar
    );
}
